#ifdef WIN32

#pragma once


#include "Helper.h"
#include "apcomdef.h"
#include "JMCommonDependenciesInterface.h"
#include "ConfigInfoDef.h"
#include "ConfigInfoInterface.h"
#include "XmppMgr\XMppMgrInterface.h"
#include "csfunified/services/interface/ConfigValue.h"
#include "csfunified/services/interface/Contact.h"
#include "csfunified/services/interface/ContactService.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csf/Timer.hpp"
#include "csf/RWLock.hpp"

#include "csfunified/services/interface/PropertyNotifier.h"

#include "services/impl/MeetingServiceObjectManager.h"

namespace CSFUnified
{
	using namespace JabberMeeting;
	using namespace MeetingStackCap;

	class JabberWerxCommonHelper : public ICommonDependenciesDelegate,
								   public csf::TimerCallback
	{
	public:
		virtual ~JabberWerxCommonHelper(void);

		static JabberWerxCommonHelper& getInstance();

		virtual wstring GetMyAccountName();
		virtual wstring GetMyAccountDisplayName();
		virtual wstring GetMyAccountEmail();
		virtual wstring GetBuddyDispName(const wstring& strBuddyName);
		virtual wstring GetBuddyEmail(const wstring &strBuddyName);
		virtual wstring GetBuddyURIWithEmailaddress(const wstring& strEmailaddress);
		virtual BOOL IsAccount(const wstring& strSessionName);
		virtual BOOL IsSignedOn();
		virtual BOOL IsDSPolicyEnable(const wstring& strSessionName, int& nPolicyResult);
		virtual BOOL AutoRespPolicy(wstring const& strBuddyName, int nPolicyResult);
		virtual BOOL HasDSCapability(const wstring& strSessionName);
		virtual BOOL HasIMCapability(const wstring& strSessionName);
		virtual BOOL IsBuddyOnline(const wstring& strSessionName);
		virtual BOOL IsCupMode();
		virtual BOOL IsPhoneMode();
	
		virtual BOOL IsWbxMeetingEnabled();
		virtual wstring GetDSURL();
		virtual wstring GetDSToken();
		virtual wstring GetDSParam();

		virtual BOOL ProbeP2PDnd(wstring const& strBuddyName);
		virtual BOOL AutoRespDnd(wstring const& strBuddyName);

		virtual void AddInMeetingStatus();
		virtual void RemoveInMeetingStatus();
		virtual void AddInWebExMeetingStatus();
		virtual void RemoveInWebExMeetingStatus();
		virtual void AddSharingInWebExMeetingStatus();
		virtual void RemoveSharingInWebExMeetingStatus();
		virtual void AddInDSStatus();
		virtual void RemoveInDSStatus();
		virtual void AddSharingInDSStatus();
		virtual void RemoveSharingInDSStatus();

		virtual unsigned int GetCalendarAutoRefreshTime();

		// listen to CapabilityChanged
		virtual void OnCapabilityChanged();
	public:
		void InitHelper( SMART_PTR_NS::shared_ptr<UnifiedFactory> UnifiedFactory );
		bool IsJIDChanged();

		string GetUserName();

		void SetListMeetingDate(const SYSTEMTIME *const sysTime = NULL);
		void SetEnableSpecialInWebExMeetingPresence(bool isEnable);
		void onUpdateMeetingList(const wstring& meetingListData);
		void ClearMeetingList();

	protected:
		virtual void onTimerFired(csf::TimerHelper *timer);
		bool isInOnlineMeeting();
		void ParseMeetingList(const wstring& meetingListData);
		bool ParseWBXMeetingStartEndTime(void* pDetail, long& lStartTime, long& lEndTime);
		void ChangeInWebExMeetingStatus(bool isInWebExMeeting);
		void DispatchChangeInWebExMeetingStatus(bool isInWebExMeeting);

	private:
		JabberWerxCommonHelper(void);

	private:
		SMART_PTR_NS::shared_ptr<Contact> contact;
		SMART_PTR_NS::shared_ptr<UnifiedFactory> m_UnifiedFactory;

		csf::TimerHelper *m_TimerHelper;
		csf::RWLock mLock;
		bool m_isSpecialInWebExMeetingPresenceEnable;
		bool m_isRealInWebExMeeting;
		bool m_isInWebExMeeting;
		bool m_isToday;
		vector<pair<long long, long long> > m_WebExMeetingTime;

		MeetingServiceObjectManager* m_pMeetingServiceObjectManager;
		JabberServiceProvider* m_pJabberServiceProvider;
        JabberServiceSink* m_pJabberServiceSink;
	};
}

#endif